# Apollo Chrome Extension

This project is a Chrome extension designed for scraping data from Apollo.io. It provides a user-friendly interface to interact with the scraped data.

## Project Structure

```
Apollo
├── src
│   ├── background.js        # Background script for managing events and tasks
│   ├── content.js          # Content script for scraping data from Apollo.io
│   ├── popup
│   │   ├── popup.html      # HTML structure for the popup interface
│   │   ├── popup.js        # JavaScript logic for the popup
│   │   └── popup.css       # Styles for the popup interface
│   └── manifest.json       # Configuration file for the Chrome extension
├── assets
│   └── icon.png            # Icon for the Chrome extension
└── README.md               # Documentation for the project
```

## Installation

1. Clone the repository to your local machine.
2. Open Chrome and navigate to `chrome://extensions/`.
3. Enable "Developer mode" in the top right corner.
4. Click on "Load unpacked" and select the `Apollo` folder.

## Usage

- Click on the extension icon in the Chrome toolbar to open the popup.
- Use the interface to initiate data scraping from Apollo.io.
- The scraped data will be displayed in the popup for easy access.

## Contributing

Feel free to submit issues or pull requests for improvements and bug fixes.